<?php


// Database connection
$db_host = "localhost";
$db_user = "weniumdemo_vps";
$db_pass = "weniumdemo_vps";
$db_name = "weniumdemo_vps";

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get admin data
$admin_id = $_SESSION['admin_id'];
$stmt = $conn->prepare("SELECT name, email, created_at FROM admins WHERE id = ?");
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$result = $stmt->get_result();
$admin = $result->fetch_assoc();

// Handle ticket reply
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_reply'])) {
    $ticket_id = $_POST['ticket_id'];
    $reply_message = $_POST['reply_message'];
    
    $stmt = $conn->prepare("INSERT INTO ticket_replies (ticket_id, user_id, message, created_at, is_admin) VALUES (?, ?, ?, NOW(), 1)");
    $stmt->bind_param("iis", $ticket_id, $admin_id, $reply_message);
    $stmt->execute();
    
    // Update ticket status to "answered" if it was "open"
    $stmt = $conn->prepare("UPDATE tickets SET status = 'answered' WHERE id = ? AND status = 'open'");
    $stmt->bind_param("i", $ticket_id);
    $stmt->execute();
    
    header("Location: admin_ticket.php?view=" . $ticket_id);
    exit;
}

// Handle ticket status change
if (isset($_GET['change_status'])) {
    $ticket_id = $_GET['ticket_id'];
    $new_status = $_GET['change_status'];
    
    $stmt = $conn->prepare("UPDATE tickets SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $new_status, $ticket_id);
    $stmt->execute();
    
    header("Location: admin_ticket.php?view=" . $ticket_id);
    exit;
}

// Handle ticket assignment
if (isset($_GET['assign_to'])) {
    $ticket_id = $_GET['ticket_id'];
    $admin_id = $_GET['assign_to'];
    
    $stmt = $conn->prepare("UPDATE tickets SET assigned_admin_id = ? WHERE id = ?");
    $stmt->bind_param("ii", $admin_id, $ticket_id);
    $stmt->execute();
    
    header("Location: admin_ticket.php?view=" . $ticket_id);
    exit;
}

// Get all tickets
$tickets = [];
$query = "SELECT t.id, t.subject, t.department, t.priority, t.status, t.created_at, 
                 u.name as user_name, a.name as admin_name
          FROM tickets t
          LEFT JOIN users u ON t.user_id = u.id
          LEFT JOIN admins a ON t.assigned_admin_id = a.id
          ORDER BY t.created_at DESC";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    $tickets[] = $row;
}

// Get all admins for assignment
$admins = [];
$result = $conn->query("SELECT id, name FROM admins");
while ($row = $result->fetch_assoc()) {
    $admins[] = $row;
}

// Get single ticket details if viewing
$current_ticket = null;
$ticket_replies = [];
if (isset($_GET['view'])) {
    $ticket_id = $_GET['view'];
    
    // Get ticket details
    $stmt = $conn->prepare("SELECT t.id, t.subject, t.department, t.priority, t.status, t.message, t.created_at, 
                                   u.name as user_name, u.email as user_email, a.name as admin_name
                            FROM tickets t
                            JOIN users u ON t.user_id = u.id
                            LEFT JOIN admins a ON t.assigned_admin_id = a.id
                            WHERE t.id = ?");
    $stmt->bind_param("i", $ticket_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $current_ticket = $result->fetch_assoc();
    
    if ($current_ticket) {
        // Get ticket replies
        $stmt = $conn->prepare("SELECT tr.id, tr.message, tr.created_at, 
                                       CASE 
                                           WHEN tr.is_admin = 1 THEN a.name
                                           ELSE u.name
                                       END as name,
                                       CASE 
                                           WHEN tr.is_admin = 1 THEN a.email
                                           ELSE u.email
                                       END as email,
                                       tr.is_admin
                                FROM ticket_replies tr
                                LEFT JOIN users u ON tr.user_id = u.id AND tr.is_admin = 0
                                LEFT JOIN admins a ON tr.user_id = a.id AND tr.is_admin = 1
                                WHERE tr.ticket_id = ?
                                ORDER BY tr.created_at ASC");
        $stmt->bind_param("i", $ticket_id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $ticket_replies[] = $row;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wenium VPS - Admin Support Tickets</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary: #5025d1;
            --primary-light: rgba(80, 37, 209, 0.1);
            --secondary: #8a87ff;
            --text: #fff;
            --dark: #2d3748;
            --light: #f7fafc;
            --gray: #e2e8f0;
            --danger: #e53e3e;
            --warning: #dd6b20;
            --success: #38a169;
            --info: #3182ce;
            --sidebar-width: 260px;
            --header-height: 70px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #f5f7fa;
            color: #4a5568;
            line-height: 1.6;
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            background: white;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
            position: fixed;
            height: 100vh;
            transition: all 0.3s;
            z-index: 100;
        }
        
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
            height: var(--header-height);
            display: flex;
            align-items: center;
        }
        
        .sidebar-header h2 {
            color: var(--primary);
            font-size: 1.5rem;
            font-weight: 700;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-category {
            padding: 0 20px 10px;
            font-size: 0.75rem;
            text-transform: uppercase;
            color: #718096;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .menu-item:hover {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .menu-item.active {
            background-color: var(--primary-light);
            color: var(--primary);
            border-left: 3px solid var(--primary);
        }
        
        .menu-item i {
            margin-right: 12px;
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
        }
        
        /* Main Content Styles */
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            transition: all 0.3s;
        }
        
        .header {
            height: var(--header-height);
            background: white;
            box-shadow: 0 1px 15px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            position: sticky;
            top: 0;
            z-index: 10;
        }
        
        .header-left h1 {
            font-size: 1.5rem;
            color: var(--dark);
        }
        
        .header-right {
            display: flex;
            align-items: center;
        }
        
        .user-profile {
            display: flex;
            align-items: center;
            cursor: pointer;
            position: relative;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-right: 10px;
        }
        
        .user-name {
            font-weight: 500;
        }
        
        .user-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 10px 0;
            min-width: 200px;
            display: none;
        }
        
        .user-profile:hover .user-dropdown {
            display: block;
        }
        
        .dropdown-item {
            padding: 10px 20px;
            display: flex;
            align-items: center;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .dropdown-item:hover {
            background-color: #f5f7fa;
            color: var(--primary);
        }
        
        .dropdown-item i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .dropdown-divider {
            border-top: 1px solid var(--gray);
            margin: 5px 0;
        }
        
        .content {
            padding: 30px;
        }
        
        .welcome-banner {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
            position: relative;
            overflow: hidden;
        }
        
        .welcome-banner::before {
            content: '';
            position: absolute;
            top: -50px;
            right: -50px;
            width: 200px;
            height: 200px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .welcome-banner h2 {
            font-size: 1.8rem;
            margin-bottom: 10px;
        }
        
        .welcome-banner p {
            opacity: 0.9;
            max-width: 600px;
        }
        
        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .card-header {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-header h3 {
            font-size: 1.2rem;
            color: var(--dark);
        }
        
        .card-header .btn {
            background: var(--primary);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .card-header .btn:hover {
            background: #3f1eb3;
        }
        
        .card-body {
            padding: 20px;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid var(--gray);
        }
        
        th {
            background-color: #f8fafc;
            color: #718096;
            font-weight: 600;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        tr:hover {
            background-color: #f8fafc;
        }
        
        .badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: capitalize;
        }
        
        .badge-primary {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .badge-success {
            background-color: rgba(56, 161, 105, 0.1);
            color: var(--success);
        }
        
        .badge-warning {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .badge-danger {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .badge-info {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .btn-action {
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 0.8rem;
            cursor: pointer;
            transition: all 0.3s;
            border: none;
            margin-right: 5px;
        }
        
        .btn-action i {
            margin-right: 5px;
        }
        
        .btn-view {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .btn-manage {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .btn-restart {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .btn-delete {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #718096;
            font-size: 0.9rem;
        }
        
        .form-control {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid var(--gray);
            border-radius: 5px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(80, 37, 209, 0.1);
        }
        
        textarea.form-control {
            min-height: 150px;
            resize: vertical;
        }
        
        .btn-save {
            background: var(--primary);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-save:hover {
            background: #3f1eb3;
        }
        
        .ticket-conversation {
            border: 1px solid var(--gray);
            border-radius: 8px;
            overflow: hidden;
        }
        
        .ticket-message {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
        }
        
        .ticket-message:last-child {
            border-bottom: none;
        }
        
        .ticket-message-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        
        .ticket-message-user {
            font-weight: 600;
            color: var(--dark);
        }
        
        .ticket-message-date {
            color: #718096;
            font-size: 0.85rem;
        }
        
        .ticket-message-content {
            line-height: 1.6;
        }
        
        .ticket-status-actions {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        
        .status-btn {
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.9rem;
            cursor: pointer;
            border: none;
        }
        
        .status-btn.open {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .status-btn.answered {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .status-btn.closed {
            background-color: rgba(56, 161, 105, 0.1);
            color: var(--success);
        }
        
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: var(--primary);
            text-decoration: none;
            font-weight: 500;
        }
        
        .back-link i {
            margin-right: 5px;
        }
        
        .admin-badge {
            background-color: var(--primary);
            color: white;
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 0.7rem;
            margin-left: 5px;
        }
        
        .assign-dropdown {
            padding: 5px;
            border-radius: 5px;
            border: 1px solid var(--gray);
            margin-left: 10px;
        }
        
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .header {
                padding: 0 15px;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>Wenium Admin</h2>
            </div>
            
            <div class="sidebar-menu">
                <div class="menu-category">Main</div>
                <a href="admin_dashboard.php" class="menu-item">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                
                <div class="menu-category">Management</div>
                <a href="admin_vps.php" class="menu-item">
                    <i class="fas fa-server"></i>
                    <span>VPS Management</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-users"></i>
                    <span>User Management</span>
                </a>
                
                <div class="menu-category">Support</div>
                <a href="admin_ticket.php" class="menu-item active">
                    <i class="fas fa-ticket-alt"></i>
                    <span>Support Tickets</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-book"></i>
                    <span>Knowledge Base</span>
                </a>
                
                <div class="menu-category">System</div>
                <a href="#" class="menu-item">
                    <i class="fas fa-cog"></i>
                    <span>Settings</span>
                </a>
                
                <div class="menu-category">Account</div>
                <a href="#" class="menu-item">
                    <i class="fas fa-user"></i>
                    <span>Profile</span>
                </a>
                <a href="admin_logout.php" class="menu-item">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <div class="header">
                <div class="header-left">
                    <h1>Support Tickets</h1>
                </div>
                
                <div class="header-right">
                    <div class="user-profile">
                        <div class="user-avatar"><?php echo strtoupper(substr($admin['name'], 0, 1)); ?></div>
                        <div class="user-name"><?php echo htmlspecialchars($admin['name']); ?></div>
                        
                        <div class="user-dropdown">
                            <a href="#" class="dropdown-item">
                                <i class="fas fa-user"></i>
                                <span>My Profile</span>
                            </a>
                            <a href="#" class="dropdown-item">
                                <i class="fas fa-cog"></i>
                                <span>Settings</span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="admin_logout.php" class="dropdown-item">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Content -->
            <div class="content">
                <!-- Welcome Banner -->
                <div class="welcome-banner">
                    <h2>Admin Support Center</h2>
                    <p>Manage all support tickets and provide assistance to users.</p>
                </div>
                
                <?php if (isset($current_ticket)): ?>
                    <!-- View Single Ticket -->
                    <a href="admin_ticket.php" class="back-link">
                        <i class="fas fa-arrow-left"></i> Back to Tickets
                    </a>
                    
                    <div class="card">
                        <div class="card-header">
                            <h3>Ticket #<?php echo htmlspecialchars($current_ticket['id']); ?>: <?php echo htmlspecialchars($current_ticket['subject']); ?></h3>
                            <div>
                                <span class="badge 
                                    <?php 
                                    if ($current_ticket['status'] === 'open') echo 'badge-primary';
                                    elseif ($current_ticket['status'] === 'answered') echo 'badge-info';
                                    else echo 'badge-success';
                                    ?>
                                ">
                                    <?php echo htmlspecialchars(ucfirst($current_ticket['status'])); ?>
                                </span>
                                <span class="badge 
                                    <?php 
                                    if ($current_ticket['priority'] === 'high') echo 'badge-danger';
                                    elseif ($current_ticket['priority'] === 'medium') echo 'badge-warning';
                                    else echo 'badge-success';
                                    ?>
                                ">
                                    <?php echo htmlspecialchars(ucfirst($current_ticket['priority'])); ?> Priority
                                </span>
                                <?php if ($current_ticket['admin_name']): ?>
                                    <span class="badge badge-info">
                                        Assigned to: <?php echo htmlspecialchars($current_ticket['admin_name']); ?>
                                    </span>
                                <?php endif; ?>
                                
                                <!-- Assignment dropdown -->
                                <form action="admin_ticket.php" method="get" style="display: inline;">
                                    <input type="hidden" name="view" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                    <input type="hidden" name="ticket_id" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                    <select name="assign_to" class="assign-dropdown" onchange="this.form.submit()">
                                        <option value="">Assign to...</option>
                                        <?php foreach ($admins as $a): ?>
                                            <option value="<?php echo $a['id']; ?>"><?php echo htmlspecialchars($a['name']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </form>
                            </div>
                        </div>
                        
                        <div class="card-body">
                            <div class="ticket-conversation">
                                <!-- Original Ticket -->
                                <div class="ticket-message">
                                    <div class="ticket-message-header">
                                        <div class="ticket-message-user">
                                            <?php echo htmlspecialchars($current_ticket['user_name']); ?>
                                            <span class="text-muted">(User)</span>
                                        </div>
                                        <div class="ticket-message-date">
                                            <?php echo date('M j, Y \a\t g:i A', strtotime($current_ticket['created_at'])); ?>
                                        </div>
                                    </div>
                                    <div class="ticket-message-content">
                                        <p><?php echo nl2br(htmlspecialchars($current_ticket['message'])); ?></p>
                                    </div>
                                </div>
                                
                                <!-- Replies -->
                                <?php foreach ($ticket_replies as $reply): ?>
                                    <div class="ticket-message">
                                        <div class="ticket-message-header">
                                            <div class="ticket-message-user">
                                                <?php echo htmlspecialchars($reply['name']); ?>
                                                <?php if ($reply['is_admin']): ?>
                                                    <span class="admin-badge">Admin</span>
                                                <?php else: ?>
                                                    <span class="text-muted">(User)</span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="ticket-message-date">
                                                <?php echo date('M j, Y \a\t g:i A', strtotime($reply['created_at'])); ?>
                                            </div>
                                        </div>
                                        <div class="ticket-message-content">
                                            <p><?php echo nl2br(htmlspecialchars($reply['message'])); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <!-- Status Actions -->
                            <div class="ticket-status-actions">
                                <?php if ($current_ticket['status'] !== 'open'): ?>
                                    <form action="admin_ticket.php" method="get">
                                        <input type="hidden" name="view" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                        <input type="hidden" name="ticket_id" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                        <input type="hidden" name="change_status" value="open">
                                        <button type="submit" class="status-btn open">Reopen Ticket</button>
                                    </form>
                                <?php endif; ?>
                                
                                <?php if ($current_ticket['status'] !== 'answered'): ?>
                                    <form action="admin_ticket.php" method="get">
                                        <input type="hidden" name="view" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                        <input type="hidden" name="ticket_id" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                        <input type="hidden" name="change_status" value="answered">
                                        <button type="submit" class="status-btn answered">Mark as Answered</button>
                                    </form>
                                <?php endif; ?>
                                
                                <?php if ($current_ticket['status'] !== 'closed'): ?>
                                    <form action="admin_ticket.php" method="get">
                                        <input type="hidden" name="view" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                        <input type="hidden" name="ticket_id" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                        <input type="hidden" name="change_status" value="closed">
                                        <button type="submit" class="status-btn closed">Close Ticket</button>
                                    </form>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Reply Form -->
                            <form action="admin_ticket.php" method="post" style="margin-top: 30px;">
                                <input type="hidden" name="ticket_id" value="<?php echo htmlspecialchars($current_ticket['id']); ?>">
                                <div class="form-group">
                                    <label for="reply_message">Add Reply</label>
                                    <textarea id="reply_message" name="reply_message" class="form-control" required></textarea>
                                </div>
                                <button type="submit" name="submit_reply" class="btn-save">
                                    <i class="fas fa-paper-plane"></i> Submit Reply
                                </button>
                            </form>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Ticket List -->
                    <div class="card">
                        <div class="card-header">
                            <h3>All Tickets</h3>
                        </div>
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Ticket ID</th>
                                            <th>Subject</th>
                                            <th>User</th>
                                            <th>Department</th>
                                            <th>Status</th>
                                            <th>Priority</th>
                                            <th>Assigned To</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($tickets as $ticket): ?>
                                        <tr>
                                            <td>#<?php echo htmlspecialchars($ticket['id']); ?></td>
                                            <td><?php echo htmlspecialchars($ticket['subject']); ?></td>
                                            <td><?php echo htmlspecialchars($ticket['user_name']); ?></td>
                                            <td><?php echo htmlspecialchars($ticket['department']); ?></td>
                                            <td>
                                                <?php if ($ticket['status'] === 'open'): ?>
                                                    <span class="badge badge-primary">Open</span>
                                                <?php elseif ($ticket['status'] === 'answered'): ?>
                                                    <span class="badge badge-info">Answered</span>
                                                <?php else: ?>
                                                    <span class="badge badge-success">Closed</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($ticket['priority'] === 'high'): ?>
                                                    <span class="badge badge-danger">High</span>
                                                <?php elseif ($ticket['priority'] === 'medium'): ?>
                                                    <span class="badge badge-warning">Medium</span>
                                                <?php else: ?>
                                                    <span class="badge badge-success">Low</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo $ticket['admin_name'] ? htmlspecialchars($ticket['admin_name']) : 'Unassigned'; ?></td>
                                            <td><?php echo date('M j, Y', strtotime($ticket['created_at'])); ?></td>
                                            <td>
                                                <a href="admin_ticket.php?view=<?php echo htmlspecialchars($ticket['id']); ?>" class="btn-action btn-view">
                                                    <i class="fas fa-eye"></i> View
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script>
        // Mobile menu toggle
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>