<?php
$proxmoxHost = 'https://74.117.197.226:8006';  // your Proxmox IP or hostname
$username = 'root@pam';                        // your username with realm (root@pam)
$password = 'Hammad@@1122';              // your password

function proxmoxLogin($host, $username, $password) {
    $url = $host . '/api2/json/access/ticket';

    $postData = http_build_query([
        'username' => $username,
        'password' => $password
    ]);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        die('Login curl error: ' . curl_error($ch));
    }
    curl_close($ch);

    $result = json_decode($response, true);
    if (isset($result['data']['ticket'])) {
        return $result['data'];
    } else {
        die('Login failed: ' . $response);
    }
}

function proxmoxApiRequest($host, $endpoint, $ticket) {
    $url = $host . '/api2/json' . $endpoint;

    $headers = [
        "Cookie: PVEAuthCookie=$ticket"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        die('API curl error: ' . curl_error($ch));
    }
    curl_close($ch);

    return json_decode($response, true);
}

// 1. Login to Proxmox
$loginData = proxmoxLogin($proxmoxHost, $username, $password);
$ticket = $loginData['ticket'];
$csrfToken = $loginData['CSRFPreventionToken']; // needed for POST/PUT/DELETE requests (not used here)

// 2. Get nodes list
$nodesResponse = proxmoxApiRequest($proxmoxHost, '/nodes', $ticket);
if (!isset($nodesResponse['data'])) {
    die('Failed to fetch nodes');
}

$allCTs = [];
foreach ($nodesResponse['data'] as $node) {
    $nodeName = $node['node'];

    // 3. Get LXC containers on node
    $ctResponse = proxmoxApiRequest($proxmoxHost, "/nodes/$nodeName/lxc", $ticket);
    if (isset($ctResponse['data'])) {
        foreach ($ctResponse['data'] as $ct) {
            $ct['node'] = $nodeName;
            $allCTs[] = $ct;
        }
    }
}

// 4. Output JSON response
header('Content-Type: application/json');
echo json_encode([
    'success' => true,
    'count' => count($allCTs),
    'vps' => $allCTs
], JSON_PRETTY_PRINT);
