<?php
session_start();

// Check if user is logged in
if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Database connection
$db_host = "localhost";
$db_user = "weniumdemo_vps";
$db_pass = "weniumdemo_vps";
$db_name = "weniumdemo_vps";

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT name, email, created_at FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Get VPS instances (sample data - replace with your actual query)
$vps_instances = [
    ['id' => 1, 'name' => 'Production Server', 'ip' => '192.168.1.100', 'status' => 'active', 'plan' => 'Business', 'expiry' => '2023-12-31'],
    ['id' => 2, 'name' => 'Development Server', 'ip' => '192.168.1.101', 'status' => 'suspended', 'plan' => 'Starter', 'expiry' => '2023-11-15'],
    ['id' => 3, 'name' => 'Backup Server', 'ip' => '192.168.1.102', 'status' => 'pending', 'plan' => 'Professional', 'expiry' => '2024-01-20']
];

// Get tickets (sample data - replace with your actual query)
$tickets = [
    ['id' => 1, 'subject' => 'Server Downtime', 'status' => 'open', 'priority' => 'high', 'created' => '2023-10-01'],
    ['id' => 2, 'subject' => 'Billing Inquiry', 'status' => 'closed', 'priority' => 'medium', 'created' => '2023-09-15'],
    ['id' => 3, 'subject' => 'Migration Request', 'status' => 'in-progress', 'priority' => 'low', 'created' => '2023-10-05']
];

// Get billing history (sample data - replace with your actual query)
$billing_history = [
    ['id' => 1, 'description' => 'Business Plan - October 2023', 'amount' => 49.99, 'date' => '2023-10-01', 'status' => 'paid'],
    ['id' => 2, 'description' => 'Domain Renewal', 'amount' => 14.99, 'date' => '2023-09-15', 'status' => 'paid'],
    ['id' => 3, 'description' => 'Professional Plan - November 2023', 'amount' => 29.99, 'date' => '2023-11-01', 'status' => 'pending']
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wenium VPS - Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary: #5025d1;
            --primary-light: rgba(80, 37, 209, 0.1);
            --secondary: #8a87ff;
            --text: #fff;
            --dark: #2d3748;
            --light: #f7fafc;
            --gray: #e2e8f0;
            --danger: #e53e3e;
            --warning: #dd6b20;
            --success: #38a169;
            --info: #3182ce;
            --sidebar-width: 260px;
            --header-height: 70px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #f5f7fa;
            color: #4a5568;
            line-height: 1.6;
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            background: white;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
            position: fixed;
            height: 100vh;
            transition: all 0.3s;
            z-index: 100;
        }
        
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
            height: var(--header-height);
            display: flex;
            align-items: center;
        }
        
        .sidebar-header h2 {
            color: var(--primary);
            font-size: 1.5rem;
            font-weight: 700;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-category {
            padding: 0 20px 10px;
            font-size: 0.75rem;
            text-transform: uppercase;
            color: #718096;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .menu-item:hover {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .menu-item.active {
            background-color: var(--primary-light);
            color: var(--primary);
            border-left: 3px solid var(--primary);
        }
        
        .menu-item i {
            margin-right: 12px;
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
        }
        
        /* Main Content Styles */
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            transition: all 0.3s;
        }
        
        .header {
            height: var(--header-height);
            background: white;
            box-shadow: 0 1px 15px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            position: sticky;
            top: 0;
            z-index: 10;
        }
        
        .header-left h1 {
            font-size: 1.5rem;
            color: var(--dark);
        }
        
        .header-right {
            display: flex;
            align-items: center;
        }
        
        .user-profile {
            display: flex;
            align-items: center;
            cursor: pointer;
            position: relative;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-right: 10px;
        }
        
        .user-name {
            font-weight: 500;
        }
        
        .user-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 10px 0;
            min-width: 200px;
            display: none;
        }
        
        .user-profile:hover .user-dropdown {
            display: block;
        }
        
        .dropdown-item {
            padding: 10px 20px;
            display: flex;
            align-items: center;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .dropdown-item:hover {
            background-color: #f5f7fa;
            color: var(--primary);
        }
        
        .dropdown-item i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .dropdown-divider {
            border-top: 1px solid var(--gray);
            margin: 5px 0;
        }
        
        .content {
            padding: 30px;
        }
        
        .welcome-banner {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
            position: relative;
            overflow: hidden;
        }
        
        .welcome-banner::before {
            content: '';
            position: absolute;
            top: -50px;
            right: -50px;
            width: 200px;
            height: 200px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .welcome-banner h2 {
            font-size: 1.8rem;
            margin-bottom: 10px;
        }
        
        .welcome-banner p {
            opacity: 0.9;
            max-width: 600px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 1.2rem;
        }
        
        .stat-icon.primary {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .stat-icon.success {
            background-color: rgba(56, 161, 105, 0.1);
            color: var(--success);
        }
        
        .stat-icon.warning {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .stat-icon.danger {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .stat-title {
            font-size: 0.9rem;
            color: #718096;
        }
        
        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--dark);
        }
        
        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .card-header {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-header h3 {
            font-size: 1.2rem;
            color: var(--dark);
        }
        
        .card-header .btn {
            background: var(--primary);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .card-header .btn:hover {
            background: #3f1eb3;
        }
        
        .card-body {
            padding: 20px;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid var(--gray);
        }
        
        th {
            background-color: #f8fafc;
            color: #718096;
            font-weight: 600;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        tr:hover {
            background-color: #f8fafc;
        }
        
        .badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: capitalize;
        }
        
        .badge-primary {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .badge-success {
            background-color: rgba(56, 161, 105, 0.1);
            color: var(--success);
        }
        
        .badge-warning {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .badge-danger {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .badge-info {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .btn-action {
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 0.8rem;
            cursor: pointer;
            transition: all 0.3s;
            border: none;
            margin-right: 5px;
        }
        
        .btn-action i {
            margin-right: 5px;
        }
        
        .btn-view {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .btn-manage {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .btn-restart {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .btn-delete {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .tab-container {
            margin-bottom: 30px;
        }
        
        .tabs {
            display: flex;
            border-bottom: 1px solid var(--gray);
            margin-bottom: 20px;
        }
        
        .tab {
            padding: 10px 20px;
            cursor: pointer;
            color: #718096;
            font-weight: 500;
            position: relative;
        }
        
        .tab.active {
            color: var(--primary);
        }
        
        .tab.active::after {
            content: '';
            position: absolute;
            bottom: -1px;
            left: 0;
            width: 100%;
            height: 2px;
            background-color: var(--primary);
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .profile-section {
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
        }
        
        .profile-card {
            flex: 1;
            min-width: 300px;
        }
        
        .profile-info {
            margin-bottom: 20px;
        }
        
        .profile-info h4 {
            margin-bottom: 10px;
            color: #718096;
            font-size: 0.9rem;
        }
        
        .profile-info p {
            font-size: 1rem;
            color: var(--dark);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #718096;
            font-size: 0.9rem;
        }
        
        .form-control {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid var(--gray);
            border-radius: 5px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(80, 37, 209, 0.1);
        }
        
        .btn-save {
            background: var(--primary);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-save:hover {
            background: #3f1eb3;
        }
        
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .header {
                padding: 0 15px;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>Wenium</h2>
            </div>
            
            <div class="sidebar-menu">
                <div class="menu-category">Main</div>
                <a href="#" class="menu-item active">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                
                <div class="menu-category">Services</div>
                <a href="vps-management.php" class="menu-item">
                    <i class="fas fa-server"></i>
                    <span>VPS Management</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-network-wired"></i>
                    <span>Networking</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-database"></i>
                    <span>Databases</span>
                </a>
                
                <div class="menu-category">Support</div>
                <a href="ticket.php" class="menu-item">
                    <i class="fas fa-ticket-alt"></i>
                    <span>Tickets</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-book"></i>
                    <span>Knowledge Base</span>
                </a>
                
                <div class="menu-category">Billing</div>
                <a href="#" class="menu-item">
                    <i class="fas fa-credit-card"></i>
                    <span>Invoices</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-history"></i>
                    <span>Billing History</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-wallet"></i>
                    <span>Payment Methods</span>
                </a>
                
                <div class="menu-category">Account</div>
                <a href="#" class="menu-item">
                    <i class="fas fa-user"></i>
                    <span>Profile</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-shield-alt"></i>
                    <span>Security</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <div class="header">
                <div class="header-left">
                    <h1>Dashboard</h1>
                </div>
                
                <div class="header-right">
                    <div class="user-profile">
                        <div class="user-avatar"><?php echo strtoupper(substr($user['name'], 0, 1)); ?></div>
                        <div class="user-name"><?php echo htmlspecialchars($user['name']); ?></div>
                        
                        <div class="user-dropdown">
                            <a href="#" class="dropdown-item">
                                <i class="fas fa-user"></i>
                                <span>My Profile</span>
                            </a>
                            <a href="#" class="dropdown-item">
                                <i class="fas fa-cog"></i>
                                <span>Settings</span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="logout.php" class="dropdown-item">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Content -->
            <div class="content">
                <!-- Welcome Banner -->
                <div class="welcome-banner">
                    <h2>Welcome back, <?php echo htmlspecialchars($user['name']); ?>!</h2>
                    <p>Manage your VPS instances, view your billing information, and get support all from one place.</p>
                </div>
                
                <!-- Stats Grid -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div class="stat-icon primary">
                                <i class="fas fa-server"></i>
                            </div>
                            <div>
                                <div class="stat-title">Active VPS</div>
                                <div class="stat-value"><?php echo count(array_filter($vps_instances, function($vps) { return $vps['status'] === 'active'; })); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-header">
                            <div class="stat-icon success">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div>
                                <div class="stat-title">Paid Invoices</div>
                                <div class="stat-value"><?php echo count(array_filter($billing_history, function($invoice) { return $invoice['status'] === 'paid'; })); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-header">
                            <div class="stat-icon warning">
                                <i class="fas fa-exclamation-circle"></i>
                            </div>
                            <div>
                                <div class="stat-title">Pending Tickets</div>
                                <div class="stat-value"><?php echo count(array_filter($tickets, function($ticket) { return $ticket['status'] !== 'closed'; })); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-header">
                            <div class="stat-icon danger">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div>
                                <div class="stat-title">Due Payments</div>
                                <div class="stat-value"><?php echo count(array_filter($billing_history, function($invoice) { return $invoice['status'] === 'pending'; })); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Tabs Navigation -->
                <div class="tab-container">
                    <div class="tabs">
                        <div class="tab active" data-tab="vps">VPS Management</div>
                        <div class="tab" data-tab="tickets">Support Tickets</div>
                        <div class="tab" data-tab="billing">Billing</div>
                        <div class="tab" data-tab="profile">Profile</div>
                    </div>
                    
                    <!-- VPS Management Tab -->
                    <div class="tab-content active" id="vps">
                        <div class="card">
                            <div class="card-header">
                                <h3>Your VPS Instances</h3>
                                <button class="btn">
                                    <i class="fas fa-plus"></i> New VPS
                                </button>
                            </div>
                            
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>IP Address</th>
                                                <th>Status</th>
                                                <th>Plan</th>
                                                <th>Expiry Date</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($vps_instances as $vps): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($vps['name']); ?></td>
                                                <td><?php echo htmlspecialchars($vps['ip']); ?></td>
                                                <td>
                                                    <?php if ($vps['status'] === 'active'): ?>
                                                        <span class="badge badge-success">Active</span>
                                                    <?php elseif ($vps['status'] === 'suspended'): ?>
                                                        <span class="badge badge-danger">Suspended</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-warning">Pending</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo htmlspecialchars($vps['plan']); ?></td>
                                                <td><?php echo htmlspecialchars($vps['expiry']); ?></td>
                                                <td>
                                                    <button class="btn-action btn-view">
                                                        <i class="fas fa-eye"></i> View
                                                    </button>
                                                    <button class="btn-action btn-manage">
                                                        <i class="fas fa-cog"></i> Manage
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Support Tickets Tab -->
                    <div class="tab-content" id="tickets">
                        <div class="card">
                            <div class="card-header">
                                <h3>Support Tickets</h3>
                                <button class="btn">
                                    <i class="fas fa-plus"></i> New Ticket
                                </button>
                            </div>
                            
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>Ticket ID</th>
                                                <th>Subject</th>
                                                <th>Status</th>
                                                <th>Priority</th>
                                                <th>Created</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($tickets as $ticket): ?>
                                            <tr>
                                                <td>#<?php echo htmlspecialchars($ticket['id']); ?></td>
                                                <td><?php echo htmlspecialchars($ticket['subject']); ?></td>
                                                <td>
                                                    <?php if ($ticket['status'] === 'open'): ?>
                                                        <span class="badge badge-primary">Open</span>
                                                    <?php elseif ($ticket['status'] === 'closed'): ?>
                                                        <span class="badge badge-success">Closed</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-info">In Progress</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($ticket['priority'] === 'high'): ?>
                                                        <span class="badge badge-danger">High</span>
                                                    <?php elseif ($ticket['priority'] === 'medium'): ?>
                                                        <span class="badge badge-warning">Medium</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-success">Low</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo htmlspecialchars($ticket['created']); ?></td>
                                                <td>
                                                    <button class="btn-action btn-view">
                                                        <i class="fas fa-eye"></i> View
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Billing Tab -->
                    <div class="tab-content" id="billing">
                        <div class="card">
                            <div class="card-header">
                                <h3>Billing History</h3>
                                <button class="btn">
                                    <i class="fas fa-plus"></i> Add Payment Method
                                </button>
                            </div>
                            
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>Invoice #</th>
                                                <th>Description</th>
                                                <th>Amount</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($billing_history as $invoice): ?>
                                            <tr>
                                                <td>#<?php echo htmlspecialchars($invoice['id']); ?></td>
                                                <td><?php echo htmlspecialchars($invoice['description']); ?></td>
                                                <td>$<?php echo htmlspecialchars($invoice['amount']); ?></td>
                                                <td><?php echo htmlspecialchars($invoice['date']); ?></td>
                                                <td>
                                                    <?php if ($invoice['status'] === 'paid'): ?>
                                                        <span class="badge badge-success">Paid</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-warning">Pending</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button class="btn-action btn-view">
                                                        <i class="fas fa-download"></i> Download
                                                    </button>
                                                    <?php if ($invoice['status'] === 'pending'): ?>
                                                    <button class="btn-action btn-manage">
                                                        <i class="fas fa-credit-card"></i> Pay Now
                                                    </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Profile Tab -->
                    <div class="tab-content" id="profile">
                        <div class="profile-section">
                            <div class="card profile-card">
                                <div class="card-header">
                                    <h3>Profile Information</h3>
                                </div>
                                
                                <div class="card-body">
                                    <div class="profile-info">
                                        <h4>Full Name</h4>
                                        <p><?php echo htmlspecialchars($user['name']); ?></p>
                                    </div>
                                    
                                    <div class="profile-info">
                                        <h4>Email Address</h4>
                                        <p><?php echo htmlspecialchars($user['email']); ?></p>
                                    </div>
                                    
                                    <div class="profile-info">
                                        <h4>Account Created</h4>
                                        <p><?php echo htmlspecialchars($user['created_at']); ?></p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card profile-card">
                                <div class="card-header">
                                    <h3>Update Profile</h3>
                                </div>
                                
                                <div class="card-body">
                                    <form>
                                        <div class="form-group">
                                            <label for="name">Full Name</label>
                                            <input type="text" id="name" class="form-control" value="<?php echo htmlspecialchars($user['name']); ?>">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="email">Email Address</label>
                                            <input type="email" id="email" class="form-control" value="<?php echo htmlspecialchars($user['email']); ?>">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="current_password">Current Password</label>
                                            <input type="password" id="current_password" class="form-control" placeholder="Enter current password">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="new_password">New Password</label>
                                            <input type="password" id="new_password" class="form-control" placeholder="Enter new password">
                                        </div>
                                        
                                        <button type="submit" class="btn-save">
                                            <i class="fas fa-save"></i> Save Changes
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Tab functionality
        document.querySelectorAll('.tab').forEach(tab => {
            tab.addEventListener('click', () => {
                // Remove active class from all tabs and contents
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
                
                // Add active class to clicked tab and corresponding content
                tab.classList.add('active');
                const tabId = tab.getAttribute('data-tab');
                document.getElementById(tabId).classList.add('active');
            });
        });
        
        // Mobile menu toggle (you can add a button for this in the header)
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>