<?php
session_start();

// Check if user is logged in
if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Database connection
$db_host = "localhost";
$db_user = "weniumdemo_vps";
$db_pass = "weniumdemo_vps";
$db_name = "weniumdemo_vps";

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT name, email, created_at FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Get VPS instances from database (replace with your actual query)
$stmt = $conn->prepare("SELECT id, name, location, ip_address, status, created_at FROM vps_instances WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$vps_instances = $result->fetch_all(MYSQLI_ASSOC);

// Check if we're deploying a new instance
$show_deploy_form = isset($_GET['deploy']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wenium VPS - VPS Management</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary: #5025d1;
            --primary-light: rgba(80, 37, 209, 0.1);
            --secondary: #8a87ff;
            --text: #fff;
            --dark: #2d3748;
            --light: #f7fafc;
            --gray: #e2e8f0;
            --danger: #e53e3e;
            --warning: #dd6b20;
            --success: #38a169;
            --info: #3182ce;
            --sidebar-width: 260px;
            --header-height: 70px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #f5f7fa;
            color: #4a5568;
            line-height: 1.6;
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            background: white;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
            position: fixed;
            height: 100vh;
            transition: all 0.3s;
            z-index: 100;
        }
        
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
            height: var(--header-height);
            display: flex;
            align-items: center;
        }
        
        .sidebar-header h2 {
            color: var(--primary);
            font-size: 1.5rem;
            font-weight: 700;
        }
        
        .sidebar-menu {
            padding: 20px 0;
        }
        
        .menu-category {
            padding: 0 20px 10px;
            font-size: 0.75rem;
            text-transform: uppercase;
            color: #718096;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        
        .menu-item:hover {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .menu-item.active {
            background-color: var(--primary-light);
            color: var(--primary);
            border-left: 3px solid var(--primary);
        }
        
        .menu-item i {
            margin-right: 12px;
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
        }
        
        /* Main Content Styles */
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            transition: all 0.3s;
        }
        
        .header {
            height: var(--header-height);
            background: white;
            box-shadow: 0 1px 15px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            position: sticky;
            top: 0;
            z-index: 10;
        }
        
        .header-left h1 {
            font-size: 1.5rem;
            color: var(--dark);
        }
        
        .header-right {
            display: flex;
            align-items: center;
        }
        
        .user-profile {
            display: flex;
            align-items: center;
            cursor: pointer;
            position: relative;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-right: 10px;
        }
        
        .user-name {
            font-weight: 500;
        }
        
        .user-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 10px 0;
            min-width: 200px;
            display: none;
        }
        
        .user-profile:hover .user-dropdown {
            display: block;
        }
        
        .dropdown-item {
            padding: 10px 20px;
            display: flex;
            align-items: center;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .dropdown-item:hover {
            background-color: #f5f7fa;
            color: var(--primary);
        }
        
        .dropdown-item i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .dropdown-divider {
            border-top: 1px solid var(--gray);
            margin: 5px 0;
        }
        
        .content {
            padding: 30px;
        }
        
        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .card-header {
            padding: 20px;
            border-bottom: 1px solid var(--gray);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-header h3 {
            font-size: 1.2rem;
            color: var(--dark);
        }
        
        .btn {
            background: var(--primary);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
        }
        
        .btn i {
            margin-right: 8px;
        }
        
        .btn:hover {
            background: #3f1eb3;
        }
        
        .btn-secondary {
            background: #718096;
        }
        
        .btn-secondary:hover {
            background: #4a5568;
        }
        
        .card-body {
            padding: 20px;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid var(--gray);
        }
        
        th {
            background-color: #f8fafc;
            color: #718096;
            font-weight: 600;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        tr:hover {
            background-color: #f8fafc;
        }
        
        .badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: capitalize;
        }
        
        .badge-primary {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .badge-success {
            background-color: rgba(56, 161, 105, 0.1);
            color: var(--success);
        }
        
        .badge-warning {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .badge-danger {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .badge-info {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .btn-action {
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 0.8rem;
            cursor: pointer;
            transition: all 0.3s;
            border: none;
            margin-right: 5px;
        }
        
        .btn-action i {
            margin-right: 5px;
        }
        
        .btn-view {
            background-color: var(--primary-light);
            color: var(--primary);
        }
        
        .btn-manage {
            background-color: rgba(49, 130, 206, 0.1);
            color: var(--info);
        }
        
        .btn-restart {
            background-color: rgba(221, 107, 32, 0.1);
            color: var(--warning);
        }
        
        .btn-delete {
            background-color: rgba(229, 62, 62, 0.1);
            color: var(--danger);
        }
        
        .empty-state {
            text-align: center;
            padding: 50px 20px;
        }
        
        .empty-state i {
            font-size: 3rem;
            color: #cbd5e0;
            margin-bottom: 20px;
        }
        
        .empty-state h3 {
            font-size: 1.5rem;
            color: #4a5568;
            margin-bottom: 15px;
        }
        
        .empty-state p {
            color: #718096;
            max-width: 500px;
            margin: 0 auto 25px;
        }
        
        /* Deploy form styles */
        .deploy-container {
            display: <?php echo $show_deploy_form ? 'block' : 'none'; ?>;
        }
        
        .deploy-steps {
            display: flex;
            margin-bottom: 30px;
            border-bottom: 1px solid var(--gray);
        }
        
        .deploy-step {
            padding: 15px 25px;
            position: relative;
            color: #718096;
            font-weight: 500;
            cursor: pointer;
        }
        
        .deploy-step.active {
            color: var(--primary);
        }
        
        .deploy-step.active::after {
            content: '';
            position: absolute;
            bottom: -1px;
            left: 0;
            width: 100%;
            height: 2px;
            background-color: var(--primary);
        }
        
        .deploy-form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
        }
        
        .deploy-options {
            border-right: 1px solid var(--gray);
            padding-right: 30px;
        }
        
        .deploy-summary {
            position: sticky;
            top: 100px;
        }
        
        .option-group {
            margin-bottom: 30px;
        }
        
        .option-group h4 {
            margin-bottom: 15px;
            color: var(--dark);
            font-size: 1.1rem;
        }
        
        .option-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 15px;
        }
        
        .option-card {
            border: 1px solid var(--gray);
            border-radius: 8px;
            padding: 15px;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .option-card:hover {
            border-color: var(--primary);
        }
        
        .option-card.selected {
            border-color: var(--primary);
            background-color: var(--primary-light);
        }
        
        .option-card h5 {
            font-size: 0.9rem;
            margin-bottom: 5px;
            color: var(--dark);
        }
        
        .option-card p {
            font-size: 0.8rem;
            color: #718096;
        }
        
        .option-card .price {
            font-weight: 600;
            color: var(--primary);
            margin-top: 10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #718096;
            font-size: 0.9rem;
        }
        
        .form-control {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid var(--gray);
            border-radius: 5px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(80, 37, 209, 0.1);
        }
        
        .summary-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .summary-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px dashed var(--gray);
        }
        
        .summary-item:last-child {
            border-bottom: none;
        }
        
        .summary-total {
            font-weight: 600;
            font-size: 1.2rem;
            color: var(--primary);
        }
        
        .payment-methods {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        
        .payment-method {
            border: 1px solid var(--gray);
            border-radius: 8px;
            padding: 15px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .payment-method:hover {
            border-color: var(--primary);
        }
        
        .payment-method.selected {
            border-color: var(--primary);
            background-color: var(--primary-light);
        }
        
        .payment-method i {
            font-size: 2rem;
            margin-bottom: 10px;
            color: #4a5568;
        }
        
        .btn-save {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 5px;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s;
            width: 100%;
            margin-top: 20px;
        }
        
        .btn-save:hover {
            background: #3f1eb3;
        }
        
        .btn-back {
            background: #e2e8f0;
            color: #4a5568;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
        }
        
        .btn-back i {
            margin-right: 8px;
        }
        
        .btn-back:hover {
            background: #cbd5e0;
        }
        
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .header {
                padding: 0 15px;
            }
            
            .deploy-form {
                grid-template-columns: 1fr;
            }
            
            .deploy-options {
                border-right: none;
                padding-right: 0;
                border-bottom: 1px solid var(--gray);
                padding-bottom: 30px;
                margin-bottom: 30px;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>Wenium</h2>
            </div>
            
            <div class="sidebar-menu">
                <div class="menu-category">Main</div>
                <a href="dashboard.php" class="menu-item">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                
                <div class="menu-category">Services</div>
                <a href="vps-management.php" class="menu-item active">
                    <i class="fas fa-server"></i>
                    <span>VPS Management</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-network-wired"></i>
                    <span>Networking</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-database"></i>
                    <span>Databases</span>
                </a>
                
                <div class="menu-category">Support</div>
                <a href="ticket.php" class="menu-item">
                    <i class="fas fa-ticket-alt"></i>
                    <span>Tickets</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-book"></i>
                    <span>Knowledge Base</span>
                </a>
                
                <div class="menu-category">Billing</div>
                <a href="#" class="menu-item">
                    <i class="fas fa-credit-card"></i>
                    <span>Invoices</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-history"></i>
                    <span>Billing History</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-wallet"></i>
                    <span>Payment Methods</span>
                </a>
                
                <div class="menu-category">Account</div>
                <a href="#" class="menu-item">
                    <i class="fas fa-user"></i>
                    <span>Profile</span>
                </a>
                <a href="#" class="menu-item">
                    <i class="fas fa-shield-alt"></i>
                    <span>Security</span>
                </a>
                <a href="logout.php" class="menu-item">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <div class="header">
                <div class="header-left">
                    <h1>VPS Management</h1>
                </div>
                
                <div class="header-right">
                    <div class="user-profile">
                        <div class="user-avatar"><?php echo strtoupper(substr($user['name'], 0, 1)); ?></div>
                        <div class="user-name"><?php echo htmlspecialchars($user['name']); ?></div>
                        
                        <div class="user-dropdown">
                            <a href="#" class="dropdown-item">
                                <i class="fas fa-user"></i>
                                <span>My Profile</span>
                            </a>
                            <a href="#" class="dropdown-item">
                                <i class="fas fa-cog"></i>
                                <span>Settings</span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="logout.php" class="dropdown-item">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Content -->
            <div class="content">
                <?php if(!$show_deploy_form): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3>Your VPS Instances</h3>
                            <a href="vps-management.php?deploy=true" class="btn">
                                <i class="fas fa-plus"></i> New VPS
                            </a>
                        </div>
                        
                        <div class="card-body">
                            <?php if(count($vps_instances) > 0): ?>
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>Server</th>
                                                <th>Location</th>
                                                <th>IP Address</th>
                                                <th>Status</th>
                                                <th>Operation</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($vps_instances as $vps): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($vps['name']); ?></td>
                                                <td><?php echo htmlspecialchars($vps['location']); ?></td>
                                                <td><?php echo htmlspecialchars($vps['ip_address']); ?></td>
                                                <td>
                                                    <?php if ($vps['status'] === 'active'): ?>
                                                        <span class="badge badge-success">Active</span>
                                                    <?php elseif ($vps['status'] === 'suspended'): ?>
                                                        <span class="badge badge-danger">Suspended</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-warning">Pending</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button class="btn-action btn-view">
                                                        <i class="fas fa-eye"></i> View
                                                    </button>
                                                    <button class="btn-action btn-manage">
                                                        <i class="fas fa-cog"></i> Manage
                                                    </button>
                                                    <button class="btn-action btn-restart">
                                                        <i class="fas fa-redo"></i> Restart
                                                    </button>
                                                    <button class="btn-action btn-delete">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="empty-state">
                                    <i class="fas fa-server"></i>
                                    <h3>No Instances</h3>
                                    <p>Deploy a new server at any of our worldwide datacenter locations</p>
                                    <a href="vps-management.php?deploy=true" class="btn">
                                        <i class="fas fa-plus"></i> Deploy New Instance
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="deploy-container">
                        <a href="vps-management.php" class="btn-back">
                            <i class="fas fa-arrow-left"></i> Back to VPS List
                        </a>
                        
                        <h2 style="margin: 20px 0;">Deploy New Instance</h2>
                        
                        <div class="card">
                            <div class="card-body">
                                <div class="alert" style="background-color: #fff3cd; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
                                    <strong>Note:</strong> When you first deploy a host, you need to recharge in your account, otherwise you will not be able to deploy the host! 
                                    <a href="#" style="color: var(--primary);">Recharge</a>
                                </div>
                                
                                <div class="deploy-steps">
                                    <div class="deploy-step active">1. Configuration</div>
                                    <div class="deploy-step">2. Payment</div>
                                    <div class="deploy-step">3. Deployment</div>
                                </div>
                                
                                <div class="deploy-form">
                                    <div class="deploy-options">
                                        <div class="option-group">
                                            <h4>Location</h4>
                                            <div class="option-grid">
                                                <div class="option-card selected">
                                                    <h5>Sofia</h5>
                                                    <p>Bulgaria</p>
                                                    <span class="badge badge-warning">Hot</span>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Bangkok</h5>
                                                    <p>Thailand</p>
                                                    <span class="badge badge-warning">Hot</span>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Sao Paulo</h5>
                                                    <p>Brazil</p>
                                                    <span class="badge badge-warning">Hot</span>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Frankfurt</h5>
                                                    <p>Germany</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Washington</h5>
                                                    <p>USA</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Hong Kong</h5>
                                                    <p>China</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Tokyo</h5>
                                                    <p>Japan</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Singapore</h5>
                                                    <p>Singapore</p>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="option-group">
                                            <h4>Image</h4>
                                            <div class="option-grid">
                                                <div class="option-card selected">
                                                    <h5>Ubuntu 22.04</h5>
                                                    <p>System Image</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Debian 11</h5>
                                                    <p>System Image</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>CentOS 7</h5>
                                                    <p>System Image</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Windows Server</h5>
                                                    <p>System Image</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Docker</h5>
                                                    <p>Application Image</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>cPanel</h5>
                                                    <p>Application Image</p>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="option-group">
                                            <h4>Instance</h4>
                                            <div class="option-grid">
                                                <div class="option-card selected">
                                                    <h5>1 vCPU | 2 GB</h5>
                                                    <p>Basic</p>
                                                    <div class="price">$7.71/mo</div>
                                                </div>
                                                <div class="option-card">
                                                    <h5>2 vCPU | 4 GB</h5>
                                                    <p>Standard</p>
                                                    <div class="price">$15.42/mo</div>
                                                </div>
                                                <div class="option-card">
                                                    <h5>4 vCPU | 8 GB</h5>
                                                    <p>Advanced</p>
                                                    <div class="price">$30.84/mo</div>
                                                </div>
                                                <div class="option-card">
                                                    <h5>8 vCPU | 16 GB</h5>
                                                    <p>Professional</p>
                                                    <div class="price">$61.68/mo</div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="option-group">
                                            <h4>Network</h4>
                                            <div class="option-grid">
                                                <div class="option-card selected">
                                                    <h5>Pay-By-Traffic</h5>
                                                    <p>1000 GB included</p>
                                                </div>
                                                <div class="option-card">
                                                    <h5>Pay-By-Bandwidth</h5>
                                                    <p>100 Mbps</p>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="option-group">
                                            <h4>Storage</h4>
                                            <div class="form-group">
                                                <label for="system-disk">System Disk</label>
                                                <select id="system-disk" class="form-control">
                                                    <option value="50">50 GB</option>
                                                    <option value="100">100 GB</option>
                                                    <option value="200">200 GB</option>
                                                </select>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="data-disk">Data Disk (Optional)</label>
                                                <select id="data-disk" class="form-control">
                                                    <option value="0">None</option>
                                                    <option value="50">50 GB</option>
                                                    <option value="100">100 GB</option>
                                                    <option value="200">200 GB</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="option-group">
                                            <h4>Hostname</h4>
                                            <div class="form-group">
                                                <input type="text" class="form-control" value="server-<?php echo rand(1000, 9999); ?>">
                                            </div>
                                        </div>
                                        
                                        <div class="option-group">
                                            <h4>Authentication</h4>
                                            <div class="form-group">
                                                <select class="form-control">
                                                    <option>Password</option>
                                                    <option>SSH Key</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="deploy-summary">
                                        <div class="summary-card">
                                            <h4 style="margin-bottom: 20px;">Summary</h4>
                                            
                                            <div class="summary-item">
                                                <span>Location</span>
                                                <span>Sofia</span>
                                            </div>
                                            
                                            <div class="summary-item">
                                                <span>Image</span>
                                                <span>Ubuntu 22.04</span>
                                            </div>
                                            
                                            <div class="summary-item">
                                                <span>Instance</span>
                                                <span>1 vCPU 2 GB</span>
                                            </div>
                                            
                                            <div class="summary-item">
                                                <span>Network</span>
                                                <span>Pay-By-Traffic (1000 GB)</span>
                                            </div>
                                            
                                            <div class="summary-item">
                                                <span>Storage</span>
                                                <span>50 GB</span>
                                            </div>
                                            
                                            <div class="summary-item summary-total">
                                                <span>Total</span>
                                                <span>$7.71/mo</span>
                                            </div>
                                        </div>
                                        
                                        <div class="summary-card">
                                            <h4 style="margin-bottom: 15px;">Payment Method</h4>
                                            
                                            <div class="payment-methods">
                                                <div class="payment-method selected">
                                                    <i class="fab fa-paypal"></i>
                                                    <div>PayPal</div>
                                                </div>
                                                <div class="payment-method">
                                                    <i class="fab fa-cc-stripe"></i>
                                                    <div>Stripe</div>
                                                </div>
                                                <div class="payment-method">
                                                    <i class="fas fa-university"></i>
                                                    <div>Bank Transfer</div>
                                                </div>
                                                <div class="payment-method">
                                                    <i class="fas fa-wallet"></i>
                                                    <div>Account Balance</div>
                                                </div>
                                            </div>
                                            
                                            <div class="alert" style="background-color: #fff3cd; padding: 15px; border-radius: 5px; margin-top: 20px;">
                                                The deployment host requires you to recharge your account first!
                                            </div>
                                            
                                            <button class="btn-save">
                                                <i class="fas fa-shopping-cart"></i> Place Order & Pay
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script>
        // Tab functionality for deploy steps
        document.querySelectorAll('.deploy-step').forEach(step => {
            step.addEventListener('click', () => {
                document.querySelectorAll('.deploy-step').forEach(s => s.classList.remove('active'));
                step.classList.add('active');
            });
        });
        
        // Option card selection
        document.querySelectorAll('.option-card').forEach(card => {
            card.addEventListener('click', () => {
                // Remove selected class from siblings
                card.parentNode.querySelectorAll('.option-card').forEach(c => c.classList.remove('selected'));
                // Add selected class to clicked card
                card.classList.add('selected');
                
                // Update summary if needed
                updateSummary();
            });
        });
        
        // Payment method selection
        document.querySelectorAll('.payment-method').forEach(method => {
            method.addEventListener('click', () => {
                // Remove selected class from siblings
                method.parentNode.querySelectorAll('.payment-method').forEach(m => m.classList.remove('selected'));
                // Add selected class to clicked method
                method.classList.add('selected');
            });
        });
        
        // Update summary based on selections
        function updateSummary() {
            // This function would update the summary based on selected options
            // For now it's just a placeholder
        }
        
        // Mobile menu toggle (you can add a button for this in the header)
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>